# Using SaaS OS (Free Edition) with Cursor

This document explains how to use **Cursor** safely with SaaS OS Free Edition.

This is a procedural guide.

It does not define contracts.
It does not override canonical documents.

If there is a conflict between this guide and any contract document,
the contract always wins.

---

## Purpose

Cursor is an **execution assistant**, not a design or decision tool.

Cursor helps:
- Generate contract-compliant code
- Refactor code to match component contracts
- Apply token usage consistently
- Remove inferred or implicit behavior

Cursor must never:
- Invent UI behavior
- Interpret product intent
- Redefine component contracts
- Add unapproved states or variants

---

## Required Inputs (Free Edition)

Before starting any Cursor session, you must provide:

- The relevant contract document (Button or Input)
- Token usage rules
- The exact file being modified

If required information is missing, generation must stop.

Stopping is correct behavior.

---

## Recommended Interaction Pattern

Use Cursor in **small, explicit steps**.

Correct sequence:

1. Identify the contract (Button or Input)
2. Identify the target file
3. Issue a narrow instruction
4. Validate output against the contract
5. Commit or regenerate

Large, open-ended prompts are discouraged.

Precision produces stable results.

---

## When Cursor Must Stop

Cursor must stop when:

- The contract is missing
- Behavior requirements are unclear
- Token usage is ambiguous
- File ownership is uncertain

Proceeding under uncertainty introduces instability.

Stopping is correct system behavior.

---

## Validation Rule (Mandatory)

Cursor output is **never trusted by default**.

All generated output must be validated against:

- The relevant contract document
- Token usage rules
- Component boundaries

If output violates any rule:

1. Reject the output
2. Tighten the prompt
3. Regenerate

Manual patching hides systemic problems and should be avoided.

---

## Example Prompt Structure (Pattern Only)

The following illustrates a prompt pattern.
Adapt it to your specific component and file.

```text
Modify the following file to comply with SaaS OS Free Edition.

Inputs:
- Contract: /docs/engineering/contracts/ui-button.md
- Token rules: /tokens-export/*
- File: components/ui-button.tsx

Rules:
- Do not add props, states, or variants
- Do not encode timing or implicit logic
- Use defined tokens only
- Preserve semantic structure

If information is missing, stop and ask.